<?php

/*
 * This file is part of the tmilos/scim-schema package.
 *
 * (c) Milos Tomic <tmilos@gmail.com>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace Tmilos\ScimSchema\Builder;

use Tmilos\ScimSchema\Model\v1\Schema;
use Tmilos\ScimSchema\ScimConstantsV1;

class SchemaBuilderV1 extends SchemaBuilder
{
    protected static $schemas = array(
        ScimConstantsV1::SCHEMA_GROUP => array(
            'id' => 'urn:scim:schemas:core:1.0:Group',
            'schema' => 'urn:scim:schemas:core:1.0',
            'name' => 'Group',
            'description' => 'Group resource.',
            'attributes' => array(
                array(
                    'name' => 'displayName',
                    'description' => 'A human-readable name for the group.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'members',
                    'description' => 'A list of members of the group.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the type of resource, e.g., \'User\' or \'Group\'.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'User',
                                'Group',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'immutable',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => null,
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => null,
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'value',
                            'description' => 'Identifier of the member of this group.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'immutable',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => 'The URI corresponding to a SCIM resource that is a member of this group.',
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'immutable',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => array(
                                'User',
                                'Group',
                            ),
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'schemas',
                    'description' => null,
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'always',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'id',
                    'description' => 'A unique identifier for a SCIM resource as defined by the service provider.',
                    'type' => 'string',
                    'caseExact' => true,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'always',
                    'uniqueness' => 'server',
                ),
                array(
                    'name' => 'externalId',
                    'description' => 'An identifier for the resource as defined by the provisioning client.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'meta',
                    'description' => null,
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'always',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'resourceType',
                            'description' => 'The name of the resource type of the resource.',
                            'type' => 'string',
                            'caseExact' => true,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'created',
                            'description' => 'The DateTime that the resource was added to the service provider.',
                            'type' => 'datetime',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'lastModified',
                            'description' => 'The most recent DateTime that the details of this resource were updated at the service provider.',
                            'type' => 'datetime',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'location',
                            'description' => 'The URI of the resource being returned.',
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'version',
                            'description' => 'The version of the resource being returned.',
                            'type' => 'string',
                            'caseExact' => true,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
            ),
            'externalId' => null,
            'meta' => array(
                'resourceType' => 'Schema',
                'created' => '0001-01-01T00:00:00Z',
                'lastModified' => '0001-01-01T00:00:00Z',
                'location' => 'http://localhost:9091/scim/v1/schemas/urn:scim:schemas:core:1.0:Group',
                'version' => 'W/"F57BE29D14171D1FDD6C41E7A5C616AE7B631728"',
            ),
        ),
        ScimConstantsV1::SCHEMA_SCHEMA => array(
            'id' => 'urn:scim:schemas:core:1.0:Schema',
            'schema' => 'urn:scim:schemas:core:1.0',
            'name' => 'Schema',
            'description' => 'Specifies the schema that describes a SCIM schema.',
            'attributes' => array(
                array(
                    'name' => 'schema',
                    'description' => null,
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'name',
                    'description' => 'The schema\'s human-readable name. When applicable, service providers MUST specify the name, e.g., \'User\'.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'description',
                    'description' => 'The schema\'s human-readable description. When applicable, service providers MUST specify the description.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'attributes',
                    'description' => 'A complex attribute that includes the attributes of a schema.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'canonicalValues',
                            'description' => 'A collection of suggested canonical values that MAY be used (e.g., "work" and "home"). In some cases, service providers MAY choose to ignore unsupported values.',
                            'type' => 'SCIM data-type of the associated attribute type being defined.',
                            'multiValued' => true,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'caseExact',
                            'description' => 'A boolean value that specifies whether or not a string attribute is case sensitive.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'description',
                            'description' => 'A human-readable description of the attribute.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'multiValued',
                            'description' => 'A boolean value indicating an attribute\'s plurality.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'mutability',
                            'description' => 'A single keyword indicating the circumstances under which the value of the attribute can be (re)defined.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'readOnly',
                                'readWrite',
                                'immutable',
                                'writeOnly',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'name',
                            'description' => 'The attribute\'s name.',
                            'type' => 'string',
                            'caseExact' => true,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'required',
                            'description' => 'A Boolean value that specifies whether or not the attribute is required.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'returned',
                            'description' => 'A single keyword that indicates when an attribute and associated values are returned in response to a GET request or in response to a PUT, POST, or PATCH request.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'always',
                                'never',
                                'default',
                                'request',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'referenceTypes',
                            'description' => 'A multi-valued array of JSON strings that indicate the SCIM resource types that may be referenced.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'A SCIM resource type (e.g., "User" or "Group")',
                                'external',
                                'uri',
                            ),
                            'caseExact' => false,
                            'multiValued' => true,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'subAttributes',
                            'description' => 'Used to define the sub-attributes of a complex attribute.',
                            'type' => 'complex',
                            'multiValued' => true,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'The attribute\'s data type. Valid values include \'string\', \'complex\', \'boolean\', \'decimal\', \'integer\', \'dateTime\', \'reference\', \'binary\'.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'string',
                                'complex',
                                'boolean',
                                'decimal',
                                'integer',
                                'dateTime',
                                'reference',
                                'binary',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'uniqueness',
                            'description' => 'A single keyword value that specifies how the service provider enforces uniqueness of attribute values.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'none',
                                'server',
                                'global',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'id',
                    'description' => 'The unique URI of the schema.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'externalId',
                    'description' => 'An identifier for the resource as defined by the provisioning client.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'meta',
                    'description' => null,
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'resourceType',
                            'description' => 'The name of the resource type of the resource.',
                            'type' => 'string',
                            'caseExact' => true,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'created',
                            'description' => 'The DateTime that the resource was added to the service provider.',
                            'type' => 'datetime',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'lastModified',
                            'description' => 'The most recent DateTime that the details of this resource were updated at the service provider.',
                            'type' => 'datetime',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'location',
                            'description' => 'The URI of the resource being returned.',
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'version',
                            'description' => 'The version of the resource being returned.',
                            'type' => 'string',
                            'caseExact' => true,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
            ),
            'externalId' => null,
            'meta' => array(
                'resourceType' => 'Schema',
                'created' => '0001-01-01T00:00:00Z',
                'lastModified' => '0001-01-01T00:00:00Z',
                'location' => 'http://localhost:9091/scim/v1/schemas/urn:scim:schemas:core:1.0:Schema',
                'version' => 'W/"8F0731A43909A8DB52FF3E35DE5940E5387979A1"',
            ),
        ),
        ScimConstantsV1::SCHEMA_USER => array(
            'id' => 'urn:scim:schemas:core:1.0:User',
            'schema' => 'urn:scim:schemas:core:1.0',
            'name' => 'User',
            'description' => 'User resource.',
            'attributes' => array(
                array(
                    'name' => 'userName',
                    'description' => 'Unique identifier for the User, typically used by the user to directly authenticate to the service provider. Each User MUST include a non-empty userName value.This identifier MUST be unique across the service provider\'s entire set of Users. REQUIRED.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'server',
                ),
                array(
                    'name' => 'name',
                    'description' => 'The components of the user\'s real name. Providers MAY return just the full name as a single string in the formatted sub-attribute, or they MAY return just the individual component attributes using the other sub-attributes, or they MAY return both.If both variants are returned, they SHOULD be describing the same name, with the formatted name indicating how the component attributes should be combined.',
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'formatted',
                            'description' => 'The full name, including all middle names, titles, and suffixes as appropriate, formatted for display (e.g., \'Ms. Barbara J Jensen, III\').',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'familyName',
                            'description' => 'The family name of the User, or last name in most Western languages (e.g., \'Jensen\' given the full name \'Ms. Barbara J Jensen, III\').',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'givenName',
                            'description' => 'The given name of the User, or first name in most Western languages (e.g., \'Barbara\' given the full name \'Ms. Barbara J Jensen, III\').',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'middleName',
                            'description' => 'The middle name(s) of the User (e.g., \'Jane\' given the full name \'Ms. Barbara J Jensen, III\').',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'honorificPrefix',
                            'description' => 'The honorific prefix(es) of the User, or title in most Western languages (e.g., \'Ms.\' given the full name \'Ms. Barbara J Jensen, III\').',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'honorificSuffix',
                            'description' => 'The honorific suffix(es) of the User, or suffix in most Western languages(e.g., \'III\' given the full name \'Ms. Barbara J Jensen, III\').',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'displayName',
                    'description' => 'The name of the User, suitable for display to end-users.The name SHOULD be the full name of the User being described, if known.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'nickName',
                    'description' => 'The casual way to address the user in real life, e.g., \'Bob\' or \'Bobby\' instead of \'Robert\'. This attribute SHOULD NOT be used to represent a User\'s username (e.g., \'bjensen\' or \'mpepperidge\').',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'profileUrl',
                    'description' => 'A fully qualified URL pointing to a page representing the User\'s online profile.',
                    'type' => 'reference',
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'referenceTypes' => array(
                        'external',
                    ),
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'title',
                    'description' => 'The user\'s title, such as \'Vice President\'.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'userType',
                    'description' => 'Used to identify the relationship between the organization and the user. Typical values used might be \'Contractor\', \'Employee\', \'Intern\', \'Temp\', \'External\', and \'Unknown\', but any value may be used.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'preferredLanguage',
                    'description' => 'Indicates the User\'s preferred written or spoken language.Generally used for selecting a localized user interface; e.g., \'en-US\' specifies the language English and country US.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'locale',
                    'description' => 'Used to indicate the User\'s default location for purposes of localizing items such as currency, date time format, or numerical representations.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'timezone',
                    'description' => 'The User\'s time zone in the \'Olson\' time zone database format, e.g., \'America/Los_Angeles\'.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'active',
                    'description' => 'A Boolean value indicating the User\'s administrative status.',
                    'type' => 'boolean',
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'password',
                    'description' => 'The User\'s cleartext password. This attribute is intended to be used as a means to specify an initial password when creating a new User or to reset an existing User\'s password.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'writeOnly',
                    'required' => false,
                    'returned' => 'never',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'emails',
                    'description' => 'Email addresses for the user. The value SHOULD be canonicalized by the service provider, e.g., \'bjensen@example.com\' instead of \'bjensen@EXAMPLE.COM\'.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'work\' or \'home\'.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'work',
                                'home',
                                'other',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A Boolean value indicating the \'primary\' or preferred attribute value for this attribute, e.g., the preferred mailing address or primary email address.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'A human-readable name, primarily used for display purposes.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'value',
                            'description' => 'Email address value.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => null,
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'phoneNumbers',
                    'description' => 'Phone numbers for the User. The value SHOULD be canonicalized by the service provider according to the format specified in RFC 3966, e.g., \'tel:+1-201-555-0123\'.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'work\', \'home\', \'mobile\'.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'work',
                                'home',
                                'mobile',
                                'fax',
                                'pager',
                                'other',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A boolean value indicating the \'primary\' or preferred attribute value for this attribute, e.g., the preferred phone number or primary phone number.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'A human-readable name, primarily used for display purposes.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'value',
                            'description' => 'Phone number of the user.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => null,
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'ims',
                    'description' => 'Instant messaging addresses for the User.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'aim\', \'gtalk\', \'xmpp\'.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'aim',
                                'gtalk',
                                'icq',
                                'xmpp',
                                'msn',
                                'skype',
                                'qq',
                                'yahoo',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A Boolean value indicating the \'primary\' or preferred attribute value for this attribute, e.g., the preferred messenger or primary messenger.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'A human-readable name, primarily used for display purposes.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'value',
                            'description' => 'Instant messaging address for the user.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => null,
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'photos',
                    'description' => 'URLs of photos of the User.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => 'URL of a photo of the user.',
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => array(
                                'external',
                            ),
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, i.e., \'photo\' or \'thumbnail\'.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'photo',
                                'thumbnail',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A Boolean value indicating the \'primary\' or preferred attribute value for this attribute, e.g., the preferred photo or thumbnail.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => null,
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => null,
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'addresses',
                    'description' => 'A physical mailing address for this User.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'formatted',
                            'description' => 'The full mailing address, formatted for display or use with a mailing label. This attribute MAY contain newlines.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'streetAddress',
                            'description' => 'The full street address component, which may include house number, street name, P.O. box, and multi-line extended street address information. This attribute MAY contain newlines.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'locality',
                            'description' => 'The city or locality component.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'region',
                            'description' => 'The state or region component.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'postalCode',
                            'description' => 'The zip code or postal code component.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'country',
                            'description' => 'The country name component.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'work\' or \'home\'.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'work',
                                'home',
                                'other',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A boolean value indicating the \'primary\' or preferred attribute value for this attribute.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'A human-readable name, primarily used for display purposes.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'value',
                            'description' => null,
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => null,
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'groups',
                    'description' => 'A list of groups to which the user belongs, either through direct membership, through nested groups, or dynamically calculated.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'direct\' or \'indirect\'.',
                            'type' => 'string',
                            'canonicalValues' => array(
                                'direct',
                                'indirect',
                            ),
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A boolean value indicating the \'primary\' or preferred attribute value for this attribute.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'A human-readable name, primarily used for display purposes.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'value',
                            'description' => 'The identifier of the user\'s group.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => 'The URI of the corresponding \'Group\' resource to which the user belongs.',
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => array(
                                'Group',
                            ),
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'entitlements',
                    'description' => 'A list of entitlements for the User that represent a thing the User has.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'work\' or \'home\'.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A boolean value indicating the \'primary\' or preferred attribute value for this attribute.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'A human-readable name, primarily used for display purposes.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'value',
                            'description' => 'The value of an entitlement.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => null,
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'roles',
                    'description' => 'A list of roles for the User that collectively represent who the User is, e.g., \'Student\', \'Faculty\'.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'type',
                            'description' => 'A label indicating the attribute\'s function, e.g., \'work\' or \'home\'.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => 'A boolean value indicating the \'primary\' or preferred attribute value for this attribute.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => 'A human-readable name, primarily used for display purposes.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'value',
                            'description' => 'The value of a role.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => null,
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'x509Certificates',
                    'description' => 'A list of certificates issued to the User.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => 'The value of an X.509 certificate.',
                            'type' => 'binary',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => null,
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => null,
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => null,
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => null,
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'schemas',
                    'description' => null,
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'always',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'id',
                    'description' => 'A unique identifier for a SCIM resource as defined by the service provider.',
                    'type' => 'string',
                    'caseExact' => true,
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'always',
                    'uniqueness' => 'server',
                ),
                array(
                    'name' => 'externalId',
                    'description' => 'An identifier for the resource as defined by the provisioning client.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'meta',
                    'description' => null,
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'resourceType',
                            'description' => 'The name of the resource type of the resource.',
                            'type' => 'string',
                            'caseExact' => true,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'created',
                            'description' => 'The DateTime that the resource was added to the service provider.',
                            'type' => 'datetime',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'lastModified',
                            'description' => 'The most recent DateTime that the details of this resource were updated at the service provider.',
                            'type' => 'datetime',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'location',
                            'description' => 'The URI of the resource being returned.',
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'version',
                            'description' => 'The version of the resource being returned.',
                            'type' => 'string',
                            'caseExact' => true,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
            ),
            'externalId' => null,
            'meta' => array(
                'resourceType' => 'Schema',
                'created' => '0001-01-01T00:00:00Z',
                'lastModified' => '0001-01-01T00:00:00Z',
                'location' => 'http://localhost:9091/scim/v1/schemas/urn:scim:schemas:core:1.0:User',
                'version' => 'W/"7B32B77F0591B527021ECCD8A548B9E400D4413A"',
            ),
        ),
        ScimConstantsV1::SCHEMA_ENTERPRISE_USER => array(
            'id' => 'urn:scim:schemas:extension:enterprise:1.0',
            'schema' => 'urn:scim:schemas:core:1.0',
            'name' => null,
            'description' => 'Enterprise user.',
            'attributes' => array(
                array(
                    'name' => 'employeeNumber',
                    'description' => null,
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'costCenter',
                    'description' => null,
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'organization',
                    'description' => null,
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'division',
                    'description' => null,
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'department',
                    'description' => null,
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'manager',
                    'description' => null,
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'value',
                            'description' => 'The "id" of the SCIM resource representing the user\'s manager.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => 'The URI of the SCIM resource representing the user\'s manager.',
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'displayName',
                            'description' => 'The displayName of the user\'s manager.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
            ),
            'externalId' => null,
            'meta' => array(
                'resourceType' => 'Schema',
                'created' => '0001-01-01T00:00:00Z',
                'lastModified' => '0001-01-01T00:00:00Z',
                'location' => 'http://localhost:9091/scim/v1/schemas/urn:scim:schemas:extension:enterprise:1.0',
                'version' => 'W/"4E3F49246DCA6C2FC7E7F368DD9A15DB2B22C183"',
            ),
        ),
        ScimConstantsV1::SCHEMA_SERVICE_PROVIDER_CONFIG => array(
            'id' => 'urn:scim:schemas:core:1.0:Service Provider Configuration',
            'schema' => 'urn:scim:schemas:core:1.0',
            'name' => 'Service Provider Configuration',
            'description' => 'Schema for representing the service provider\'s configuration',
            'attributes' => array(
                array(
                    'name' => 'documentationUri',
                    'description' => 'An HTTP-addressable URL pointing to the service provider\'s human-consumable help documentation.',
                    'type' => 'reference',
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => false,
                    'returned' => 'default',
                    'referenceTypes' => array(
                        'external',
                    ),
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'patch',
                    'description' => 'A complex type that specifies PATCH configuration options.',
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'supported',
                            'description' => 'A boolean value specifying whether or not the operation is supported.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'bulk',
                    'description' => 'A complex type that specifies bulk configuration options.',
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'maxOperations',
                            'description' => 'An integer value specifying the maximum number of operations.',
                            'type' => 'integer',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'maxPayloadSize',
                            'description' => 'An integer value specifying the maximum payload size in bytes.',
                            'type' => 'integer',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'supported',
                            'description' => 'A boolean value specifying whether or not the operation is supported.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'filter',
                    'description' => 'A complex type that specifies FILTER options.',
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'maxResults',
                            'description' => 'An integer value specifying the maximum number of resources returned in a response.',
                            'type' => 'integer',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'supported',
                            'description' => 'A boolean value specifying whether or not the operation is supported.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'changePassword',
                    'description' => 'A complex type that specifies configuration options related to changing a password.',
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'supported',
                            'description' => 'A boolean value specifying whether or not the operation is supported.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'sort',
                    'description' => 'A complex type that specifies Sort configuration options.',
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'supported',
                            'description' => 'A boolean value specifying whether or not the operation is supported.',
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'etag',
                    'description' => 'A complex type that specifies ETag configuration options.',
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'isWeak',
                            'description' => null,
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'supported',
                            'description' => null,
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'authenticationSchemes',
                    'description' => 'A multi-valued complex type that specifies supported authentication scheme properties.',
                    'type' => 'complex',
                    'multiValued' => true,
                    'mutability' => 'readOnly',
                    'required' => true,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'name',
                            'description' => 'The common authentication scheme name, e.g., HTTP Basic.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'description',
                            'description' => 'A description of the authentication scheme.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'specUri',
                            'description' => 'An HTTP-addressable URL pointing to the authentication scheme\'s specification.',
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => array(
                                'external',
                            ),
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'documentationUri',
                            'description' => 'An HTTP-addressable URL pointing to the authentication scheme\'s usage documentation.',
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => array(
                                'external',
                            ),
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'type',
                            'description' => 'The authentication scheme.',
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => true,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'primary',
                            'description' => null,
                            'type' => 'boolean',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'display',
                            'description' => null,
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'value',
                            'description' => null,
                            'type' => 'string',
                            'caseExact' => false,
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => '$ref',
                            'description' => null,
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readWrite',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
                array(
                    'name' => 'schemas',
                    'description' => null,
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => true,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'always',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'id',
                    'description' => 'A unique identifier for a SCIM resource as defined by the service provider.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'never',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'externalId',
                    'description' => 'An identifier for the resource as defined by the provisioning client.',
                    'type' => 'string',
                    'caseExact' => false,
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'never',
                    'uniqueness' => 'none',
                ),
                array(
                    'name' => 'meta',
                    'description' => null,
                    'type' => 'complex',
                    'multiValued' => false,
                    'mutability' => 'readWrite',
                    'required' => false,
                    'returned' => 'default',
                    'uniqueness' => 'none',
                    'subAttributes' => array(
                        array(
                            'name' => 'resourceType',
                            'description' => 'The name of the resource type of the resource.',
                            'type' => 'string',
                            'caseExact' => true,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'created',
                            'description' => 'The DateTime that the resource was added to the service provider.',
                            'type' => 'datetime',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'lastModified',
                            'description' => 'The most recent DateTime that the details of this resource were updated at the service provider.',
                            'type' => 'datetime',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'location',
                            'description' => 'The URI of the resource being returned.',
                            'type' => 'reference',
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'referenceTypes' => null,
                            'uniqueness' => 'none',
                        ),
                        array(
                            'name' => 'version',
                            'description' => 'The version of the resource being returned.',
                            'type' => 'string',
                            'caseExact' => true,
                            'multiValued' => false,
                            'mutability' => 'readOnly',
                            'required' => false,
                            'returned' => 'default',
                            'uniqueness' => 'none',
                        ),
                    ),
                ),
            ),
            'externalId' => null,
            'meta' => array(
                'resourceType' => 'Schema',
                'created' => '0001-01-01T00:00:00Z',
                'lastModified' => '0001-01-01T00:00:00Z',
                'location' => 'http://localhost:9091/scim/v1/schemas/urn:scim:schemas:core:1.0:Service%20Provider%20Configuration',
                'version' => 'W/"7D42A92B1CF945D7A8572A34DBF6D4F4960B856B"',
            ),
        ),
    );

    public function __construct($schemasEndpointUrl = null)
    {
        parent::__construct($schemasEndpointUrl ?: 'http://localhost/'.ScimConstantsV1::ENDPOINT_SCHEMAS);
    }

    protected function getSchemaClass()
    {
        return Schema::class;
    }

    /**
     * @return Schema
     */
    public function getGroup()
    {
        return $this->get(ScimConstantsV1::SCHEMA_GROUP);
    }

    /**
     * @return Schema
     */
    public function getSchema()
    {
        return $this->get(ScimConstantsV1::SCHEMA_SCHEMA);
    }

    /**
     * @return Schema
     */
    public function getUser()
    {
        return $this->get(ScimConstantsV1::SCHEMA_USER);
    }

    /**
     * @return Schema
     */
    public function getEnterpriseUser()
    {
        return $this->get(ScimConstantsV1::SCHEMA_ENTERPRISE_USER);
    }

    /**
     * @return Schema
     */
    public function getServiceProviderConfig()
    {
        return $this->get(ScimConstantsV1::SCHEMA_SERVICE_PROVIDER_CONFIG);
    }
}
