<?php
if (!class_exists('Merlin')) {
    return;
}

/**
 * Extends melin class WooCommerce key
 */
class Retheme_Merlin extends Merlin {
    /**
     * Activate the EDD license.
     *
     * This code was taken from the EDD licensing addon theme example code
     * (`activate_license` method of the `EDD_Theme_Updater_Admin` class).
     *
     * @param string $license The license key.
     *
     * @return array
     */
    protected function edd_activate_license($key) {
        $success = false;

        // Strings passed in from the config file.
        $strings = $this->strings;

        // Theme Name.
        $theme = ucfirst($this->theme);

        // Remove "Child" from the current theme name, if it's installed.
        $theme = str_replace(' Child', '', $theme);

        // Text strings.
        $success_message = $strings['license-json-success%s'];

        // API Manager
        if (class_exists('BagusCore\Activation')) {
            $license = new \BagusCore\Activation([
                'product_key' => $key,
            ]);
        } else {
            $license = new \Retheme\Activation([
                'product_key' => $key,
            ]);
        }

        $status = $license->activate();
        $message = sprintf(esc_html($status['message']), $theme);

        if ($status['result'] == 'success') {
            $success = true;
        } else {
            $success = false;
        }

        return compact('success', 'message');
    }
}

/** 
 * Set directory locations, text strings, and settings.
 */
new Retheme_Merlin(
    $config = array(
        'directory' => 'vendor/merlin',
        'merlin_url' => 'merlin',
        'parent_slug' => (!in_array('bagus-core/core.php', apply_filters('active_plugins', get_option('active_plugins'))))? 'themes.php': '',
        'capability' => 'manage_options',
        'child_action_btn_url' => 'https://codex.wordpress.org/child_themes',
        'dev_mode' => true,
        'license_step' => true,
        'license_required' => false,
        'license_help_url' => '',
        'edd_remote_api_url' => '',
        'edd_item_name' => RT_THEME_NAME,
        'edd_theme_slug' => RT_THEME_SLUG,
        'ready_big_button_url' => site_url(),
        'redirect_switch_theme' => get_theme_mod('demo_imported') ? false : true,
    ),

    $strings = array(
        'admin-menu' => esc_html__('Theme Setup', 'retheme-admin'),
        /* translators: 1: Title Tag 2: Theme Name 3: Closing Title Tag */
        'title%s%s%s%s' => esc_html__('%1$s%2$s Themes &lsaquo; Theme Setup: %3$s%4$s', 'retheme-admin'),
        'return-to-dashboard' => esc_html__('Kembali ke Dasbor Admin', 'retheme-admin'),
        'ignore' => esc_html__('Nonaktifkan Pengaturan Tema', 'retheme-admin'),
        'btn-skip' => esc_html__('Lewati', 'retheme-admin'),
        'btn-next' => esc_html__('Lanjutkan', 'retheme-admin'),
        'btn-start' => esc_html__('Mulai', 'retheme-admin'),
        'btn-no' => esc_html__('Batalkan', 'retheme-admin'),
        'btn-plugins-install' => esc_html__('Pasang Plugin', 'retheme-admin'),
        'btn-child-install' => esc_html__('Buat Child Theme', 'retheme-admin'),
        'btn-content-install' => esc_html__('Instal', 'retheme-admin'),
        'btn-import' => esc_html__('Impor', 'retheme-admin'),
        'btn-license-activate' => esc_html__('Aktifkan', 'retheme-admin'),
        'btn-license-skip' => esc_html__('Lewati', 'retheme-admin'),
        /* translators: Theme Name */
        'license-header%s' => esc_html__('Aktifkan %s', 'retheme-admin'),
        /* translators: Theme Name */
        'license-header-success%s' => esc_html__('%s sudah diaktifkan', 'retheme-admin'),
        /* translators: Theme Name */
        'license%s' => esc_html__('Masukan kunci lisensi untuk mendapatkan semua fitur premium, update, dan dukungan dari ThemeBagus', 'retheme-admin'),
        'license-label' => esc_html__('Kunci lisensi', 'retheme-admin'),
        'license-success%s' => esc_html__('Selamat! Tema telah diaktifkan. Mari lanjutkan ke langkah selanjutnya.', 'retheme-admin'),
        'license-json-success%s' => esc_html__('Selamat! Tema telah diaktifkan. Mari lanjutkan ke langkah selanjutnya.', 'retheme-admin'),
        'license-tooltip' => esc_html__('Butuh bantuan?', 'retheme-admin'),
        /* translators: Theme Name */
        'welcome-header%s' => esc_html__('Selamat datang di %s', 'retheme-admin'),
        'welcome-header-success%s' => esc_html__('Hi. Selamat datang kembali', 'retheme-admin'),
        'welcome%s' => esc_html__('Fitur Theme Setup ini akan membantu Anda untuk melakukan pengaturan tema, memasang plugin, dan mengimpor konten.', 'retheme-admin'),
        'welcome-success%s' => esc_html__('Anda mungkin sudah menjalankan fitur Theme Setup ini sebelumnnya. Jika ingin melanjutkannya, silakan klik tombol "Mulai" di bawah ini', 'retheme-admin'),
        'child-header' => esc_html__('Instal tema anak', 'retheme-admin'),
        'child-header-success' => esc_html__('You\'re good to go!', 'retheme-admin'),
        'child' => esc_html__('Aktifkan tema anak sehingga Anda dapat dengan mudah melakukan perubahan tanpa merusak tema utama.', 'retheme-admin'),
        'child-success%s' => esc_html__('Tema anak Anda berhasil di install dan diaktifkan', 'retheme-admin'),
        'child-action-link' => esc_html__('Pelajari lebih lanjut tentang tema anak', 'retheme-admin'),
        'child-json-success%s' => esc_html__('Tema anak Anda sudah diinstall dan diaktifkan', 'retheme-admin'),
        'child-json-already%s' => esc_html__('Tema anak Anda sudah berhasil dibuat dan sekarang sudah diaktifkan', 'retheme-admin'),
        'plugins-header' => esc_html__('Install Plugins', 'retheme-admin'),
        'plugins-header-success' => esc_html__('Mengagumkan', 'retheme-admin'),
        'plugins' => esc_html__('Mari kita instal beberapa plugin penting untuk membangun website Anda.', 'retheme-admin'),
        'plugins-success%s' => esc_html__('Semua plugin yang dibutuhkan sudah terinstall dan diperbarui.', 'retheme-admin'),
        'plugins-action-link' => esc_html__('Tingkat lanjut', 'retheme-admin'),
        'import-header' => esc_html__('Impor Konten', 'retheme-admin'),
        'import' => esc_html__('Jalankan proses import! Dapatkan tampilan dan fitur seperti yang ditampilkan di website demo.', 'retheme-admin'),
        'import-action-link' => esc_html__('Tingkat lanjut', 'retheme-admin'),
        'ready-header' => esc_html__('Proses instalasi selesai. Selamat bersenang-senang!', 'retheme-admin'),
        /* translators: Theme Author */
        'ready%s' => esc_html__('Tema Anda telah diatur. Nikmati tema baru Anda yang dikembangkan oleh ThemeBagus.', 'retheme-admin'),
        'ready-action-link' => esc_html__('Extra', 'retheme-admin'),
        'ready-big-button' => esc_html__('Kunjungi website', 'retheme-admin'),
        'ready-link-2' => sprintf('<a href="%1$s" target="_blank">%2$s</a>', RT_THEME_DOC, esc_html__('Tutorial tema', 'retheme-admin')),
        'ready-link-3' => sprintf('<a href="%1$s" target="_blank">%2$s</a>', 'https://themebagus.com/support/', esc_html__('Hubungi Tim Dukungan', 'retheme-admin')),

    )
);

/**
 * Skip Merlin generate Child Theme
 */
add_filter('wp_ajax_merlin_child_theme', '__return_false');

/**
 * Check license
 */
function merlin_check_license() {
    $license = new Retheme\Activation();
    return ($license->is_premium()) ? true : false;
}
add_filter('merlin_is_theme_registered', 'merlin_check_license');