<?php
if (! defined('ABSPATH')) {
	exit;
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function rt_setup_theme() {
	// Hook premium
	do_action('retheme_after_setup_theme');
}
add_action('after_setup_theme', 'rt_setup_theme');

/**
 * Register the required plugins for this theme.
 */
function rt_setup_required_plugins() {

	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(
		array(
			'name'     => 'Bagus - Core',
			'slug'     => 'bagus-core',
			'source'   => 'https://themebagus.com/wp-content/uploads/themebagus/bagus-core.zip',
			'required' => true,
		),
		array(
			'name'     => 'Bagus - Academia',
			'slug'     => 'bagus-academia',
			'source'   => 'https://themebagus.com/wp-content/uploads/themebagus/bagus-academia.zip',
			'required' => true,
		),
		array(
			'name'     => 'Contact Form 7',
			'slug'     => 'contact-form-7',
			'required' => false,
		),
		array(
			'name'     => 'Limit Login Attempts Reloaded',
			'slug'     => 'limit-login-attempts-reloaded',
			'required' => false,
		),
		array(
			'name'     => 'Backup - UpdraftPlus',
			'slug'     => 'updraftplus',
			'required' => false,
		),
	);

	return $plugins;
}
add_filter('ocdi/register_plugins', 'rt_setup_required_plugins');

/**
 * Get plugins list from rt_theme_required_plugins function
 */
function rt_setup_tgmpa_register($plugins) {

	$plugins = rt_setup_required_plugins();
	/*
	 * Array of configuration settings. Amend each line as needed.
	 *
	 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
	 * strings available, please help us make TGMPA even better by giving us access to these translations or by
	 * sending in a pull-request with .po file(s) with the translations.
	 *
	 * Only uncomment the strings in the config array if you want to customize the strings.
	 */
	tgmpa(
		$plugins,
		array(
			'id'           => 'rt_tgmpa',
			'default_path' => '',
			'menu'         => 'tgmpa-install-plugins', // Menu slug.
			'parent_slug'  => (! in_array('bagus-core/core.php', apply_filters('active_plugins', get_option('active_plugins')))) ? 'themes.php' : 'theme-panel',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true,
			'dismissable'  => true,
			'dismiss_msg'  => true,
			'is_automatic' => false,
			'message'      => '',
		)
	);
}
add_action('tgmpa_register', 'rt_setup_tgmpa_register');
