<?php
/**
 * Handle import files from external server
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Import files from external server
 */
function rt_import_files() {

	// Define theme slug and version
    $key = uniqid();
    $theme_name = RT_THEME_NAME;
    $theme_slug = RT_THEME_SLUG;

	return array(
		array(
			'import_file_name' => $theme_name,
            'categories' => ['Personal'],
            'import_file_url' => "https://themebagus.com/wp-content/uploads/themebagus/{$theme_slug}/{$theme_slug}-default.xml?key={$key}",
            'import_preview_image_url' => "https://themebagus.com/wp-content/uploads/themebagus/{$theme_slug}/{$theme_slug}-default.png?key={$key}",
            'preview_url' => "https://akademia.themebagus.com?key={$key}",
		),
	);
}
add_filter( 'merlin_import_files', 'rt_import_files' );
add_filter( 'ocdi/import_files', 'rt_import_files' );

/**
 * Set default options after import
 */
function rt_import_final() {

	// Set default product settings
    update_option('bagus_team_title', 'Guru & Staft');
    update_option('bagus_team_base_url', 'tim');
    update_option('bagus_team_category_base_url', 'kategori-tim');
    update_option('bagus_team_tag_base_url', 'tag-tim');
    update_option('bagus_team_post_per_page', 8);

    update_option('bagus_announcement_title', 'Pengumuman');
    update_option('bagus_announcement_base_url', 'pengumuman');
    update_option('bagus_announcement_category_base_url', 'kategori-pengumuman');
    update_option('bagus_announcement_tag_base_url', 'tag-pengumuman');
    update_option('bagus_announcement_post_per_page', 8);

    update_option('bagus_download_title', 'Download');
    update_option('bagus_download_base_url', 'download');
    update_option('bagus_download_category_base_url', 'kategori-download');
    update_option('bagus_download_tag_base_url', 'tag-download');
    update_option('bagus_download_post_per_page', 8);

    update_option('bagus_core_global_search_label', 'Cari informasi');
    update_option('bagus_core_global_search_cpt_result', 'post, announcement, download');

	// Update general site settings
	update_option( 'posts_per_page', 6 );
	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', get_page_by_path( 'home' )->ID );
	update_option( 'page_for_posts', get_page_by_path( 'blog' )->ID );

	// Set language and timezone
    update_option('WPLANG', 'id_ID');
    update_option('timezone_string', 'Asia/Jakarta');

	// Configure plugin settings if not already set
	$default_settings = array(
		'updraft_interval'          => 'weekly',
		'updraft_retain'            => 2,
		'updraft_interval_database' => 'daily',
	);

	foreach ( $default_settings as $key => $value ) {
		if ( empty( get_option( $key ) ) ) {
			update_option( $key, $value );
		}
	}

	// Deactivate unwanted plugins
	$plugins_to_deactivate = array(
		'/litespeed-cache/litespeed-cache.php',
		'/speedycache/speedycache.php',
		'/pagelayer/pagelayer.php',
		'/wp-super-cache/wp-cache.php',
		'/jetpack/jetpack.php',
	);

	foreach ( $plugins_to_deactivate as $plugin ) {
		deactivate_plugins( $plugin, true );
	}

	// Set the example post to draft
	$example_post_id = 1; // Default example post ID

	if ( get_post_status( $example_post_id ) !== 'trash' ) {
		wp_update_post(
			array(
				'ID'          => $example_post_id,
				'post_status' => 'draft',
			)
		);
	}

	// Update URL navigation in posts
	global $wpdb;
	$table_posts = "{$wpdb->prefix}posts";
	$demo_id     = RT_THEME_DEMO_ID;
	$demo_url    = RT_THEME_DEMO_URL;
	$site_url    = get_site_url();

	if ( ! empty( $demo_url ) ) {
		// Replace demo URLs in navigation content
		$wpdb->query(
			$wpdb->prepare(
				"UPDATE $table_posts SET post_content = REPLACE(post_content, %s, %s) WHERE post_type = 'wp_navigation'",
				$demo_url,
				$site_url
			)
		);

		// Replace demo uploads directory with the site's new uploads directory
		if ( ! is_multisite() && ! empty( $demo_id ) ) {
			$demo_upload_path = "{$demo_url}/wp-content/uploads/sites/{$demo_id}";
			$site_upload_path = "{$site_url}/wp-content/uploads";
			$wpdb->query(
				$wpdb->prepare(
					"UPDATE $table_posts SET post_content = REPLACE(post_content, %s, %s)",
					$demo_upload_path,
					$site_upload_path
				)
			);
		}
	}
	// Set demo imported
	set_theme_mod( 'demo_imported', true );
}
add_action( 'merlin_after_all_import', 'rt_import_final' );
add_action( 'ocdi/after_import', 'rt_import_final' );

/**
 * Set permalink after import
 */
function rt_import_set_permalink() {
	global $wp_rewrite;
	$wp_rewrite->set_permalink_structure( '/%postname%/' );
	$wp_rewrite->flush_rules();
}
add_action( 'retheme_merlin_import_final', 'rt_import_set_permalink' );

/**
 * Disable image regenerate after import
 */
add_filter( 'ocdi/regenerate_thumbnails_in_content_import', '__return_false' );
